#!/bin/sh
# Exec \
exec tclsh "$0" "$@"

set version 0.3
proc timestamp {} { return [clock format [clock seconds] -format "\[%Y-%m-%d %H:%M:%S\]" ]}

if {$tcl_platform(platform)=="unix"} {cd ~/Napalm}
set verbose  0
source "Napalm.conf"
set killings 0
set answer   ""
set msglist  {}
set skipflag 0

set logfile [open "Napalm.log" a]

proc say { what } { 
 global logfile verbose
 puts "$what"
 if { $verbose } { puts $logfile "$what" }
}

proc read_line { } {
 global sock answer logfile
 set answer [gets $sock]
 puts "| Server: \[$answer\]"
 if {[string match "-ERR*" $answer]} { 
  uplevel { 
   say "\\ [timestamp] Napalm leaving operations with $killings confirmed killings due to error \[$answer\]" 
   exit } 
  }
}

proc read_header { } {
 global sock answer from to subject
 set answer ""
 set from     ""
 set to       ""
 set subject  ""
 while {1} {
  set line [gets $sock]
  if {[string match "From:*" $line]}    { set from [string range $line 6 end ] }
  if {[string match "To:*" $line]}      { set to   [string range $line 4 end ] }
  if {[string match "Subject:*" $line]} { set subject [string range $line 9 end ] }
  if {[string match "-ERR*" $line]}     break;
  set answer "$answer \n\t$line"
  if {$line=="."} break;
 }
}

proc read_list { } {
 global sock answer msglist
 puts $sock "LIST"
 while {1} {
  set line [gets $sock]
  if {[string match "-ERR*" $line]}     break;
  if {[string match "+OK*" $line]}      continue;
  if {$line=="."}                       break;
  scan $line "%i %i" message size  
  lappend msglist [list $message $size]
 }
}

proc kill { field pattern } {
 global skipflag
 if ($skipflag==1) return;
 set FIELD   [string toupper $field]
 set PATTERN [string toupper $pattern]
 if {[string match $PATTERN $FIELD]} { 
  uplevel { 
   puts $sock "DELE $msgidx" 
   say "X Napalm killed [format %02i $msgidx]: From: \[$from\] To: \[$to\] Subject: \[$subject\]"
   if {$verbose == 0} {
    puts $logfile "[timestamp] X ([format %02i $msgidx]) From: \[$from\] To: \[$to\] Subject: \[$subject\] Size: \[$msglen bytes\]"
   }
   incr killings
   set skipflag 1
  }
 }
}

say "/ [timestamp] Napalm entering war theater, Sir. \[v$version, www.scarpaz.com\]"
puts "! Connecting to host: $hostname, port: $port"

set sock [socket $hostname $port]
fconfigure $sock -buffering line
read_line
puts $sock "USER $username"; read_line
puts $sock "PASS $password"; read_line

#scan $answer "+OK %i %i" messages size
read_list

set killings 0
for {set i 0} {$i < [llength $msglist] } {incr i} {
 set  msg      [lindex $msglist $i]
 set  msgidx   [lindex $msg 0]
 set  msglen   [lindex $msg 1]
 puts $sock    "TOP $msgidx 1"
 read_header
 puts "| [format %03i $msgidx]: From: \[$from\] To: \[$to\] Subject: \[$subject\]"
 set skipflag 0
 source "Napalm.rules"
}

puts $sock "QUIT"
read_line

say "\\ [timestamp] Napalm completed operations with $killings confirmed killings, Sir."

close $sock
close $logfile

if {$tcl_platform(platform)=="windows"} { 
	puts "Press enter to finish."
	gets stdin trash 
}